/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.validator;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.core.validator.NodeValidator;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowNodeInfoRepository;

@Component
public class NestedWorkflowNodeValidator
implements NodeValidator {
    private static final Logger log = LoggerFactory.getLogger(NestedWorkflowNodeValidator.class);
    private final WorkflowInfoRepository workflowInfoRepository;
    private final WorkflowNodeInfoRepository workflowNodeInfoRepository;

    @Override
    public void complexValidate(WorkflowNodeInfoDO node, WorkflowDAG dag) {
        if (Objects.equals(node.getJobId(), node.getWorkflowId())) {
            throw new PowerJobException("Illegal nested workflow node,Prohibit circular references!" + node.getNodeName());
        }
    }

    @Override
    public void simpleValidate(WorkflowNodeInfoDO node) {
        WorkflowInfoDO workflowInfo = (WorkflowInfoDO)this.workflowInfoRepository.findById((Object)node.getJobId()).orElseThrow(() -> new PowerJobException("Illegal nested workflow node,specified workflow is not exist,node name : " + node.getNodeName()));
        if (workflowInfo.getStatus().intValue() == SwitchableStatus.DELETED.getV()) {
            throw new PowerJobException("Illegal nested workflow node,specified workflow has been deleted,node name : " + node.getNodeName());
        }
        PEWorkflowDAG peDag = (PEWorkflowDAG)JSON.parseObject((String)workflowInfo.getPeDAG(), PEWorkflowDAG.class);
        for (PEWorkflowDAG.Node peDagNode : peDag.getNodes()) {
            Optional nestWfNodeOp = this.workflowNodeInfoRepository.findById((Object)peDagNode.getNodeId());
            if (!nestWfNodeOp.isPresent()) {
                throw new PowerJobException("Illegal nested workflow node,specified workflow is invalidate,node name : " + node.getNodeName());
            }
            if (!Objects.equals(((WorkflowNodeInfoDO)nestWfNodeOp.get()).getType(), WorkflowNodeType.NESTED_WORKFLOW.getCode())) continue;
            throw new PowerJobException("Illegal nested workflow node,specified workflow must be a simple workflow,node name : " + node.getNodeName());
        }
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.NESTED_WORKFLOW;
    }

    public NestedWorkflowNodeValidator(WorkflowInfoRepository workflowInfoRepository, WorkflowNodeInfoRepository workflowNodeInfoRepository) {
        this.workflowInfoRepository = workflowInfoRepository;
        this.workflowNodeInfoRepository = workflowNodeInfoRepository;
    }
}

