/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.apidoc.handler;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ClassUtil;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.core.MethodParameter;
import top.continew.starter.apidoc.util.ApiDocUtils;
import top.continew.starter.core.enums.BaseEnum;

public class BaseEnumParameterHandler
implements ParameterCustomizer,
PropertyCustomizer {
    public Parameter customize(Parameter parameterModel, MethodParameter methodParameter) {
        Class parameterType = methodParameter.getParameterType();
        if (!ClassUtil.isAssignable(BaseEnum.class, (Class)parameterType)) {
            return parameterModel;
        }
        String description = parameterModel.getDescription();
        if (CharSequenceUtil.contains((CharSequence)description, (CharSequence)"color:red")) {
            return parameterModel;
        }
        this.configureSchema(parameterModel.getSchema(), parameterType);
        parameterModel.setDescription(this.appendEnumDescription(description, parameterType));
        return parameterModel;
    }

    public Schema customize(Schema schema, AnnotatedType type) {
        Class<?> rawClass = this.resolveRawClass(type.getType());
        if (!ClassUtil.isAssignable(BaseEnum.class, rawClass)) {
            return schema;
        }
        this.configureSchema(schema, rawClass);
        schema.setDescription(this.appendEnumDescription(schema.getDescription(), rawClass));
        return schema;
    }

    private void configureSchema(Schema schema, Class<?> enumClass) {
        BaseEnum[] enums = (BaseEnum[])enumClass.getEnumConstants();
        List<String> valueList = Arrays.stream(enums).map(e -> e.getValue().toString()).toList();
        schema.setEnum(valueList);
        String enumValueType = ApiDocUtils.getEnumValueTypeAsString(enumClass);
        schema.setType(enumValueType);
        schema.setFormat(ApiDocUtils.resolveFormat(enumValueType));
    }

    private String appendEnumDescription(String originalDescription, Class<?> enumClass) {
        return originalDescription + "<span style='color:red'>" + ApiDocUtils.getDescMap(enumClass) + "</span>";
    }

    private Class<?> resolveRawClass(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return simpleType.getRawClass();
        }
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            return collectionType.getContentType().getRawClass();
        }
        return Object.class;
    }
}

