/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.cache.redisson.util;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.core.util.SpringUtils;

public class RedisLockUtils
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RedisLockUtils.class);
    private static final long DEFAULT_EXPIRE_TIME = 10000L;
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static volatile RedissonClient CLIENT;
    private final RLock lock;
    private boolean isLocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RedissonClient getClient() {
        if (CLIENT != null) return CLIENT;
        Class<RedisLockUtils> clazz = RedisLockUtils.class;
        synchronized (RedisLockUtils.class) {
            if (CLIENT != null) return CLIENT;
            CLIENT = (RedissonClient)SpringUtils.getBean(RedissonClient.class, (boolean)false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return CLIENT;
        }
    }

    private RedisLockUtils(RLock lock, long expireTime, long timeout, TimeUnit unit) {
        this.lock = lock;
        try {
            this.isLocked = lock.tryLock(timeout, expireTime, unit);
            if (this.isLocked) {
                log.debug("\u83b7\u53d6\u9501\u6210\u529f\uff0ckey: {}", (Object)lock.getName());
            } else {
                log.debug("\u83b7\u53d6\u9501\u5931\u8d25\uff0ckey: {}", (Object)lock.getName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("\u83b7\u53d6\u9501\u8fc7\u7a0b\u4e2d\u88ab\u4e2d\u65ad\uff0ckey: {}", (Object)lock.getName(), (Object)e);
        }
    }

    public static RedisLockUtils tryLockWithWatchdog(String key, long timeout, TimeUnit unit) {
        RLock lock = RedisLockUtils.getClient().getLock(key);
        return new RedisLockUtils(lock, -1L, timeout, unit);
    }

    public static RedisLockUtils tryLockWithWatchdog(String key, long timeout) {
        return RedisLockUtils.tryLockWithWatchdog(key, timeout, TimeUnit.MILLISECONDS);
    }

    public static RedisLockUtils tryLockWithWatchdog(String key) {
        return RedisLockUtils.tryLockWithWatchdog(key, 5000L);
    }

    public static RedisLockUtils tryLock(String key, long expireTime, long timeout, TimeUnit unit) {
        RLock lock = RedisLockUtils.getClient().getLock(key);
        return new RedisLockUtils(lock, expireTime, timeout, unit);
    }

    public static RedisLockUtils tryLock(String key, long expireTime, long timeout) {
        return RedisLockUtils.tryLock(key, expireTime, timeout, TimeUnit.MILLISECONDS);
    }

    public static RedisLockUtils tryLock(String key) {
        return RedisLockUtils.tryLock(key, 10000L, 5000L);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void close() {
        if (this.isLocked && this.lock.isHeldByCurrentThread()) {
            try {
                this.lock.unlockAsync().get();
                log.debug("\u91ca\u653e\u9501\u6210\u529f\uff0ckey: {}", (Object)this.lock.getName());
            }
            catch (Exception e) {
                log.error("\u91ca\u653e\u9501\u5931\u8d25\uff0ckey: {}", (Object)this.lock.getName(), (Object)e);
            }
        } else {
            log.debug("\u9501\u672a\u88ab\u5f53\u524d\u7ebf\u7a0b\u6301\u6709\uff0c\u65e0\u9700\u91ca\u653e\uff0ckey: {}", (Object)this.lock.getName());
        }
    }
}

