/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.util;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import top.continew.starter.core.exception.BadRequestException;
import top.continew.starter.core.util.ReflectUtils;
import top.continew.starter.core.util.validation.ValidationUtils;
import top.continew.starter.data.annotation.Query;
import top.continew.starter.data.annotation.QueryIgnore;
import top.continew.starter.data.enums.LogicalRelation;
import top.continew.starter.data.enums.QueryType;
import top.continew.starter.data.util.SqlInjectionUtils;

public class QueryWrapperHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryWrapperHelper.class);

    private QueryWrapperHelper() {
    }

    public static <T> void sort(QueryWrapper<T> queryWrapper, Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return;
        }
        for (Sort.Order order : sort) {
            String property = order.getProperty();
            queryWrapper.orderBy(true, order.isAscending(), (Object)CharSequenceUtil.toUnderlineCase((CharSequence)property));
        }
    }

    public static <Q, R> QueryWrapper<R> build(Q query) {
        return QueryWrapperHelper.build(query, Sort.unsorted());
    }

    public static <Q, R> QueryWrapper<R> build(Q query, Sort sort) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (query == null) {
            return queryWrapper;
        }
        if (sort != null && sort.isSorted()) {
            for (Sort.Order order : sort) {
                String field = CharSequenceUtil.toUnderlineCase((CharSequence)order.getProperty());
                ValidationUtils.throwIf((boolean)SqlInjectionUtils.check((String)field), (String)"\u6392\u5e8f\u5b57\u6bb5\u5305\u542b\u65e0\u6548\u5b57\u7b26", (Object[])new Object[0]);
                queryWrapper.orderBy(true, order.isAscending(), (Object)field);
            }
        }
        List fieldList = ReflectUtils.getNonStaticFields(query.getClass());
        return QueryWrapperHelper.build(query, fieldList, queryWrapper);
    }

    public static <Q, R> QueryWrapper<R> build(Q query, List<Field> fields, QueryWrapper<R> queryWrapper) {
        if (query == null) {
            return queryWrapper;
        }
        for (Field field : fields) {
            List consumers = QueryWrapperHelper.buildWrapperConsumer(query, field);
            queryWrapper.and(CollUtil.isNotEmpty(consumers), q -> consumers.forEach(arg_0 -> ((QueryWrapper)q).or(arg_0)));
        }
        return queryWrapper;
    }

    private static <Q, R> List<Consumer<QueryWrapper<R>>> buildWrapperConsumer(Q query, Field field) {
        try {
            Object fieldValue = ReflectUtil.getFieldValue(query, (Field)field);
            if (ObjectUtil.isEmpty((Object)fieldValue)) {
                return Collections.emptyList();
            }
            QueryIgnore queryIgnoreAnnotation = (QueryIgnore)AnnotationUtil.getAnnotation((AnnotatedElement)field, QueryIgnore.class);
            if (queryIgnoreAnnotation != null) {
                return Collections.emptyList();
            }
            String fieldName = ReflectUtil.getFieldName((Field)field);
            Query queryAnnotation = (Query)AnnotationUtil.getAnnotation((AnnotatedElement)field, Query.class);
            if (queryAnnotation == null) {
                return Collections.singletonList(q -> q.eq((Object)CharSequenceUtil.toUnderlineCase((CharSequence)fieldName), fieldValue));
            }
            QueryType queryType = queryAnnotation.type();
            String[] columns = queryAnnotation.columns();
            int columnLength = ArrayUtil.length((Object)columns);
            ArrayList<Consumer<QueryWrapper<R>>> consumers = new ArrayList<Consumer<QueryWrapper<R>>>(columnLength);
            if (columnLength <= 1) {
                String columnName = columnLength == 1 ? columns[0] : CharSequenceUtil.toUnderlineCase((CharSequence)fieldName);
                QueryWrapperHelper.parse(queryType, columnName, fieldValue, consumers);
                return consumers;
            }
            LogicalRelation logicalRelation = queryAnnotation.logicalRelation();
            ArrayList columnConsumers = new ArrayList();
            for (String column : columns) {
                QueryWrapperHelper.parse(queryType, column, fieldValue, columnConsumers);
            }
            if (logicalRelation == LogicalRelation.AND) {
                if (!columnConsumers.isEmpty()) {
                    consumers.add(q -> {
                        ((Consumer)columnConsumers.get(0)).accept(q);
                        columnConsumers.subList(1, columnConsumers.size()).forEach(arg_0 -> ((QueryWrapper)q).and(arg_0));
                    });
                }
            } else {
                consumers.addAll(columnConsumers);
            }
            return consumers;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Build query wrapper occurred an error: {}. Query: {}, Field: {}.", new Object[]{e.getMessage(), query, field, e});
            return Collections.emptyList();
        }
    }

    private static <R> void parse(QueryType queryType, String columnName, Object fieldValue, List<Consumer<QueryWrapper<R>>> consumers) {
        switch (queryType) {
            case EQ: {
                consumers.add(q -> q.eq((Object)columnName, fieldValue));
                break;
            }
            case NE: {
                consumers.add(q -> q.ne((Object)columnName, fieldValue));
                break;
            }
            case GT: {
                consumers.add(q -> q.gt((Object)columnName, fieldValue));
                break;
            }
            case GE: {
                consumers.add(q -> q.ge((Object)columnName, fieldValue));
                break;
            }
            case LT: {
                consumers.add(q -> q.lt((Object)columnName, fieldValue));
                break;
            }
            case LE: {
                consumers.add(q -> q.le((Object)columnName, fieldValue));
                break;
            }
            case BETWEEN: {
                ArrayList<Object> between = new ArrayList<Object>(ArrayUtil.isArray((Object)fieldValue) ? List.of((Object[])fieldValue) : (List<Object>)fieldValue);
                ValidationUtils.throwIf((between.size() != 2 ? 1 : 0) != 0, (String)"[{}] \u5fc5\u987b\u662f\u4e00\u4e2a\u8303\u56f4", (Object[])new Object[]{columnName});
                consumers.add(q -> q.between((Object)columnName, between.get(0), between.get(1)));
                break;
            }
            case LIKE: {
                consumers.add(q -> q.like((Object)columnName, fieldValue));
                break;
            }
            case LIKE_LEFT: {
                consumers.add(q -> q.likeLeft((Object)columnName, fieldValue));
                break;
            }
            case LIKE_RIGHT: {
                consumers.add(q -> q.likeRight((Object)columnName, fieldValue));
                break;
            }
            case IN: {
                ValidationUtils.throwIfEmpty((Object)fieldValue, (String)"[{}] \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{columnName});
                consumers.add(q -> q.in((Object)columnName, ArrayUtil.isArray((Object)fieldValue) ? List.of((Object[])fieldValue) : (List<Object>)fieldValue));
                break;
            }
            case NOT_IN: {
                ValidationUtils.throwIfEmpty((Object)fieldValue, (String)"[{}] \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{columnName});
                consumers.add(q -> q.notIn((Object)columnName, ArrayUtil.isArray((Object)fieldValue) ? List.of((Object[])fieldValue) : (List<Object>)fieldValue));
                break;
            }
            case IS_NULL: {
                consumers.add(q -> q.isNull((Object)columnName));
                break;
            }
            case IS_NOT_NULL: {
                consumers.add(q -> q.isNotNull((Object)columnName));
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301 [%s] \u67e5\u8be2\u7c7b\u578b".formatted(queryType));
            }
        }
    }
}

