/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.excel.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.URLUtil;
import cn.idev.excel.FastExcelFactory;
import cn.idev.excel.converters.Converter;
import cn.idev.excel.write.builder.ExcelWriterBuilder;
import cn.idev.excel.write.builder.ExcelWriterSheetBuilder;
import cn.idev.excel.write.handler.WriteHandler;
import cn.idev.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.core.exception.BaseException;
import top.continew.starter.excel.converter.ExcelBigNumberConverter;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    private ExcelUtils() {
    }

    public static <T> void export(List<T> list, String fileName, Class<T> clazz, HttpServletResponse response) {
        ExcelUtils.export(list, fileName, "Sheet1", Collections.emptySet(), clazz, response);
    }

    public static <T> void export(List<T> list, String fileName, String sheetName, Set<String> excludeColumnFieldNames, Class<T> clazz, HttpServletResponse response) {
        try {
            String exportFileName = URLUtil.encode((String)"%s_%s.xlsx".formatted(fileName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")));
            response.setHeader("Content-disposition", "attachment;filename=" + exportFileName);
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)FastExcelFactory.write((OutputStream)response.getOutputStream(), clazz).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConverter())).sheet(sheetName).excludeColumnFieldNames(excludeColumnFieldNames)).doWrite(list);
        }
        catch (Exception e) {
            log.error("Export excel occurred an error: {}. fileName: {}.", new Object[]{e.getMessage(), fileName, e});
            response.reset();
            throw new BaseException("\u5bfc\u51fa Excel \u51fa\u73b0\u9519\u8bef");
        }
    }
}

