/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;
import top.continew.starter.core.util.ClassUtils;
import top.continew.starter.core.util.ReflectUtils;
import top.continew.starter.core.util.TreeUtils;
import top.continew.starter.core.util.validation.CheckUtils;
import top.continew.starter.core.util.validation.ValidationUtils;
import top.continew.starter.data.mapper.BaseMapper;
import top.continew.starter.data.service.impl.ServiceImpl;
import top.continew.starter.data.util.QueryWrapperHelper;
import top.continew.starter.excel.util.ExcelUtils;
import top.continew.starter.extension.crud.annotation.DictModel;
import top.continew.starter.extension.crud.annotation.TreeField;
import top.continew.starter.extension.crud.autoconfigure.CrudProperties;
import top.continew.starter.extension.crud.autoconfigure.CrudTreeProperties;
import top.continew.starter.extension.crud.model.entity.BaseIdDO;
import top.continew.starter.extension.crud.model.query.PageQuery;
import top.continew.starter.extension.crud.model.query.SortQuery;
import top.continew.starter.extension.crud.model.resp.LabelValueResp;
import top.continew.starter.extension.crud.model.resp.PageResp;
import top.continew.starter.extension.crud.service.CrudService;

public class CrudServiceImpl<M extends BaseMapper<T>, T extends BaseIdDO, L, D, Q, C>
extends ServiceImpl<M, T>
implements CrudService<L, D, Q, C> {
    private Class<L> listClass;
    private Class<D> detailClass;
    private Class<Q> queryClass;
    private List<Field> queryFields;

    public PageResp<L> page(Q query, PageQuery pageQuery) {
        QueryWrapper<T> queryWrapper = this.buildQueryWrapper(query);
        this.sort(queryWrapper, (SortQuery)pageQuery);
        IPage page = ((BaseMapper)this.baseMapper).selectPage((IPage)new Page((long)pageQuery.getPage().intValue(), (long)pageQuery.getSize().intValue()), queryWrapper);
        PageResp<L> pageResp = PageResp.build(page, this.getListClass());
        pageResp.getList().forEach(this::fill);
        return pageResp;
    }

    public List<L> list(Q query, SortQuery sortQuery) {
        List<L> list = this.list(query, sortQuery, this.getListClass());
        list.forEach(this::fill);
        return list;
    }

    public List<Tree<Long>> tree(Q query, SortQuery sortQuery, boolean isSimple) {
        return this.tree(query, sortQuery, isSimple, false);
    }

    public List<Tree<Long>> tree(Q query, SortQuery sortQuery, boolean isSimple, boolean isSingleRoot) {
        Long rootId;
        TreeNodeConfig treeNodeConfig;
        List<L> list = this.list(query, sortQuery);
        if (CollUtil.isEmpty(list)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        CrudProperties crudProperties = (CrudProperties)SpringUtil.getBean(CrudProperties.class);
        CrudTreeProperties treeProperties = crudProperties.getTree();
        TreeField treeField = this.listClass.getDeclaredAnnotation(TreeField.class);
        if (isSimple) {
            treeNodeConfig = treeProperties.genTreeNodeConfig();
            rootId = treeProperties.getRootId();
        } else {
            treeNodeConfig = treeProperties.genTreeNodeConfig(treeField);
            rootId = treeField.rootId();
        }
        if (isSingleRoot) {
            return TreeUtil.build(list, (Object)rootId, (TreeNodeConfig)treeNodeConfig, (node, tree) -> this.buildTreeField(isSimple, node, (Tree<Long>)tree, treeField));
        }
        Function getId = ReflectUtils.createMethodReference(this.listClass, (String)CharSequenceUtil.genGetter((CharSequence)treeField.value()));
        Function getParentId = ReflectUtils.createMethodReference(this.listClass, (String)CharSequenceUtil.genGetter((CharSequence)treeField.parentIdKey()));
        return TreeUtils.buildMultiRoot(list, (Function)getId, (Function)getParentId, (TreeNodeConfig)treeNodeConfig, (node, tree) -> this.buildTreeField(isSimple, node, (Tree<Long>)tree, treeField));
    }

    public D get(Long id) {
        BaseIdDO entity = (BaseIdDO)super.getById((Serializable)id, false);
        Object detail = BeanUtil.toBean((Object)entity, this.getDetailClass());
        this.fill(detail);
        return (D)detail;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long create(C req) {
        this.beforeCreate(req);
        BaseIdDO entity = (BaseIdDO)BeanUtil.copyProperties(req, (Class)super.getEntityClass(), (String[])new String[0]);
        ((BaseMapper)this.baseMapper).insert((Object)entity);
        this.afterCreate(req, entity);
        return entity.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(C req, Long id) {
        this.beforeUpdate(req, id);
        BaseIdDO entity = (BaseIdDO)this.getById(id);
        BeanUtil.copyProperties(req, (Object)entity, (CopyOptions)CopyOptions.create().ignoreNullValue());
        ((BaseMapper)this.baseMapper).updateById((Object)entity);
        this.afterUpdate(req, entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<Long> ids) {
        this.beforeDelete(ids);
        ((BaseMapper)this.baseMapper).deleteByIds(ids);
        this.afterDelete(ids);
    }

    public void export(Q query, SortQuery sortQuery, HttpServletResponse response) {
        List<D> list = this.list(query, sortQuery, this.getDetailClass());
        list.forEach(this::fill);
        ExcelUtils.export(list, (String)"\u5bfc\u51fa\u6570\u636e", this.getDetailClass(), (HttpServletResponse)response);
    }

    public List<LabelValueResp> dict(Q query, SortQuery sortQuery) {
        DictModel dictModel = super.getEntityClass().getDeclaredAnnotation(DictModel.class);
        CheckUtils.throwIfNull((Object)dictModel, (String)"\u8bf7\u6dfb\u52a0\u5e76\u914d\u7f6e @DictModel \u5b57\u5178\u7ed3\u6784\u4fe1\u606f", (Object[])new Object[0]);
        List<L> list = this.list(query, sortQuery);
        ArrayList<LabelValueResp> respList = new ArrayList<LabelValueResp>(list.size());
        String labelKey = dictModel.labelKey().contains(".") ? CharSequenceUtil.subAfter((CharSequence)dictModel.labelKey(), (CharSequence)".", (boolean)true) : dictModel.labelKey();
        String valueKey = dictModel.valueKey().contains(".") ? CharSequenceUtil.subAfter((CharSequence)dictModel.valueKey(), (CharSequence)".", (boolean)true) : dictModel.valueKey();
        List<String> extraFieldNames = Arrays.stream(dictModel.extraKeys()).map(extraKey -> extraKey.contains(".") ? CharSequenceUtil.subAfter((CharSequence)extraKey, (CharSequence)".", (boolean)true) : extraKey).map(CharSequenceUtil::toCamelCase).toList();
        for (L entity : list) {
            LabelValueResp labelValueResp = new LabelValueResp();
            labelValueResp.setLabel(Convert.toStr((Object)ReflectUtil.getFieldValue(entity, (String)CharSequenceUtil.toCamelCase((CharSequence)labelKey))));
            labelValueResp.setValue(ReflectUtil.getFieldValue(entity, (String)CharSequenceUtil.toCamelCase((CharSequence)valueKey)));
            respList.add(labelValueResp);
            if (CollUtil.isEmpty(extraFieldNames)) continue;
            HashMap extraMap = MapUtil.newHashMap((int)dictModel.extraKeys().length);
            for (String extraFieldName : extraFieldNames) {
                extraMap.put(extraFieldName, ReflectUtil.getFieldValue(entity, (String)extraFieldName));
            }
            labelValueResp.setExtra((Object)extraMap);
        }
        return respList;
    }

    public Class<L> getListClass() {
        if (this.listClass == null) {
            this.listClass = ClassUtils.getTypeArguments(((Object)((Object)this)).getClass())[2];
        }
        return this.listClass;
    }

    public Class<D> getDetailClass() {
        if (this.detailClass == null) {
            this.detailClass = ClassUtils.getTypeArguments(((Object)((Object)this)).getClass())[3];
        }
        return this.detailClass;
    }

    public Class<Q> getQueryClass() {
        if (this.queryClass == null) {
            this.queryClass = ClassUtils.getTypeArguments(((Object)((Object)this)).getClass())[4];
        }
        return this.queryClass;
    }

    public List<Field> getQueryFields() {
        if (this.queryFields == null) {
            this.queryFields = ReflectUtils.getNonStaticFields(this.getQueryClass());
        }
        return this.queryFields;
    }

    protected <E> List<E> list(Q query, SortQuery sortQuery, Class<E> targetClass) {
        QueryWrapper<T> queryWrapper = this.buildQueryWrapper(query);
        this.sort(queryWrapper, sortQuery);
        List entityList = ((BaseMapper)this.baseMapper).selectList(queryWrapper);
        if (super.getEntityClass() == targetClass) {
            return entityList;
        }
        return BeanUtil.copyToList((Collection)entityList, targetClass);
    }

    protected void sort(QueryWrapper<T> queryWrapper, SortQuery sortQuery) {
        if (sortQuery == null || sortQuery.getSort().isUnsorted()) {
            return;
        }
        Sort sort = sortQuery.getSort();
        for (Sort.Order order : sort) {
            String property = order.getProperty();
            String checkProperty = property.contains(".") ? (String)CollUtil.getLast((Collection)CharSequenceUtil.split((CharSequence)property, (CharSequence)".")) : property;
            Optional<Field> optional = super.getEntityFields().stream().filter(field -> checkProperty.equals(field.getName())).findFirst();
            ValidationUtils.throwIf((boolean)optional.isEmpty(), (String)"\u65e0\u6548\u7684\u6392\u5e8f\u5b57\u6bb5 [{}]", (Object[])new Object[]{property});
            queryWrapper.orderBy(true, order.isAscending(), (Object)CharSequenceUtil.toUnderlineCase((CharSequence)property));
        }
    }

    protected QueryWrapper<T> buildQueryWrapper(Q query) {
        QueryWrapper queryWrapper = new QueryWrapper();
        return QueryWrapperHelper.build(query, this.getQueryFields(), (QueryWrapper)queryWrapper);
    }

    protected void fill(Object obj) {
    }

    protected void beforeCreate(C req) {
    }

    protected void beforeUpdate(C req, Long id) {
    }

    protected void beforeDelete(List<Long> ids) {
    }

    protected void afterCreate(C req, T entity) {
    }

    protected void afterUpdate(C req, T entity) {
    }

    protected void afterDelete(List<Long> ids) {
    }

    private void buildTreeField(boolean isSimple, L node, Tree<Long> tree, TreeField treeField) {
        tree.setId((Object)((Long)ReflectUtil.invoke(node, (String)CharSequenceUtil.genGetter((CharSequence)treeField.value()), (Object[])new Object[0])));
        tree.setParentId((Object)((Long)ReflectUtil.invoke(node, (String)CharSequenceUtil.genGetter((CharSequence)treeField.parentIdKey()), (Object[])new Object[0])));
        tree.setName((CharSequence)ReflectUtil.invoke(node, (String)CharSequenceUtil.genGetter((CharSequence)treeField.nameKey()), (Object[])new Object[0]));
        tree.setWeight((Comparable)ReflectUtil.invoke(node, (String)CharSequenceUtil.genGetter((CharSequence)treeField.weightKey()), (Object[])new Object[0]));
        if (!isSimple) {
            List fieldList = ReflectUtils.getNonStaticFields(this.listClass);
            fieldList.removeIf(f -> CharSequenceUtil.equalsAnyIgnoreCase((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{treeField.value(), treeField.parentIdKey(), treeField.nameKey(), treeField.weightKey(), treeField.childrenKey()}));
            fieldList.forEach(f -> tree.putExtra(f.getName(), ReflectUtil.invoke((Object)node, (String)CharSequenceUtil.genGetter((CharSequence)f.getName()), (Object[])new Object[0])));
        }
    }
}

