/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.datapermission.handler;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.data.enums.DatabaseType;
import top.continew.starter.data.util.MetaUtils;
import top.continew.starter.extension.datapermission.annotation.DataPermission;
import top.continew.starter.extension.datapermission.enums.DataScope;
import top.continew.starter.extension.datapermission.exception.DataPermissionException;
import top.continew.starter.extension.datapermission.model.RoleData;
import top.continew.starter.extension.datapermission.model.UserData;
import top.continew.starter.extension.datapermission.provider.DataPermissionUserDataProvider;

public class DefaultDataPermissionHandler
implements DataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataPermissionHandler.class);
    private final DataPermissionUserDataProvider dataPermissionUserDataProvider;

    public DefaultDataPermissionHandler(DataPermissionUserDataProvider dataPermissionUserDataProvider) {
        this.dataPermissionUserDataProvider = dataPermissionUserDataProvider;
    }

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        try {
            DataPermission dataPermission = this.findDataPermissionAnnotation(mappedStatementId);
            if (dataPermission != null && this.dataPermissionUserDataProvider.isFilter()) {
                return this.buildDataScopeFilter(dataPermission, where);
            }
        }
        catch (Exception e) {
            log.error("Data permission handler build data scope filter occurred an error: {}.", (Object)e.getMessage(), (Object)e);
        }
        return where;
    }

    private DataPermission findDataPermissionAnnotation(String mappedStatementId) {
        try {
            Method[] methods;
            int lastDotIndex = mappedStatementId.lastIndexOf(".");
            if (lastDotIndex == -1) {
                return null;
            }
            String className = mappedStatementId.substring(0, lastDotIndex);
            String methodName = mappedStatementId.substring(lastDotIndex + 1);
            Class<?> clazz = Class.forName(className);
            for (Method method : methods = clazz.getMethods()) {
                String name = method.getName();
                if (!CharSequenceUtil.equalsAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{name, name + "_COUNT"})) continue;
                return method.getAnnotation(DataPermission.class);
            }
        }
        catch (ClassNotFoundException e) {
            throw DataPermissionException.methodNotFound((String)mappedStatementId);
        }
        return null;
    }

    private Expression buildDataScopeFilter(DataPermission dataPermission, Expression where) {
        UserData userData = this.dataPermissionUserDataProvider.getUserData();
        if (userData == null || !userData.isValid()) {
            throw DataPermissionException.invalidUserData((String)"User data is null or invalid");
        }
        AndExpression expression = null;
        Set roles = userData.getRoles();
        for (RoleData roleData : roles) {
            DataScope dataScope = roleData.getDataScope();
            if (DataScope.ALL.equals((Object)dataScope)) {
                return where;
            }
            expression = switch (dataScope) {
                case DataScope.DEPT_AND_CHILD -> this.buildDeptAndChildExpression(dataPermission, userData, (Expression)expression);
                case DataScope.DEPT -> this.buildDeptExpression(dataPermission, userData, (Expression)expression);
                case DataScope.SELF -> this.buildSelfExpression(dataPermission, userData, (Expression)expression);
                case DataScope.CUSTOM -> this.buildCustomExpression(dataPermission, roleData, (Expression)expression);
                default -> throw DataPermissionException.unsupportedDataScope((String)dataScope.toString());
            };
        }
        return where != null ? new AndExpression(where, (Expression)new ParenthesedExpressionList(new Expression[]{expression})) : expression;
    }

    private Expression buildDeptAndChildExpression(DataPermission dataPermission, UserData userData, Expression expression) {
        Function inSetExpression;
        ParenthesedSelect subSelect = new ParenthesedSelect();
        PlainSelect select = new PlainSelect();
        select.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column(dataPermission.id()))));
        select.setFromItem((FromItem)new Table(dataPermission.deptTableAlias()));
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(dataPermission.id()));
        equalsTo.setRightExpression((Expression)new LongValue(userData.getDeptId().longValue()));
        DatabaseType databaseType = MetaUtils.getDatabaseType((DataSource)((DataSource)SpringUtil.getBean(DataSource.class)));
        if (DatabaseType.MYSQL.getDatabase().equalsIgnoreCase(databaseType.getDatabase())) {
            Function findInSetFunction = new Function();
            findInSetFunction.setName("find_in_set");
            findInSetFunction.setParameters(new ExpressionList(new Expression[]{new LongValue(userData.getDeptId().longValue()), new Column("ancestors")}));
            inSetExpression = findInSetFunction;
        } else if (DatabaseType.POSTGRE_SQL.getDatabase().equalsIgnoreCase(databaseType.getDatabase())) {
            Function concatFunction = new Function("concat", new Expression[0]);
            concatFunction.setParameters(new ExpressionList((Expression[])new ASTNodeAccessImpl[]{new Column("ancestors"), new StringValue(",")}));
            LikeExpression likeExpression = new LikeExpression();
            likeExpression.setLeftExpression((Expression)concatFunction);
            likeExpression.setRightExpression((Expression)new StringValue("%," + userData.getDeptId() + ",%"));
            inSetExpression = likeExpression;
        } else {
            throw DataPermissionException.unsupportedDatabase((String)databaseType.getDatabase());
        }
        select.setWhere((Expression)new OrExpression((Expression)equalsTo, (Expression)inSetExpression));
        subSelect.setSelect((Select)select);
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        inExpression.setRightExpression((Expression)subSelect);
        return expression != null ? new OrExpression(expression, (Expression)inExpression) : inExpression;
    }

    private Expression buildDeptExpression(DataPermission dataPermission, UserData userData, Expression expression) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        equalsTo.setRightExpression((Expression)new LongValue(userData.getDeptId().longValue()));
        return expression != null ? new OrExpression(expression, (Expression)equalsTo) : equalsTo;
    }

    private Expression buildSelfExpression(DataPermission dataPermission, UserData userData, Expression expression) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.userId()));
        equalsTo.setRightExpression((Expression)new LongValue(userData.getUserId().longValue()));
        return expression != null ? new OrExpression(expression, (Expression)equalsTo) : equalsTo;
    }

    private Expression buildCustomExpression(DataPermission dataPermission, RoleData roleData, Expression expression) {
        ParenthesedSelect subSelect = new ParenthesedSelect();
        PlainSelect select = new PlainSelect();
        select.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column(dataPermission.deptId()))));
        select.setFromItem((FromItem)new Table(dataPermission.roleDeptTableAlias()));
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(dataPermission.roleId()));
        equalsTo.setRightExpression((Expression)new LongValue(roleData.getRoleId().longValue()));
        select.setWhere((Expression)equalsTo);
        subSelect.setSelect((Select)select);
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        inExpression.setRightExpression((Expression)subSelect);
        return expression != null ? new OrExpression(expression, (Expression)inExpression) : inExpression;
    }

    private Column buildColumn(String tableAlias, String columnName) {
        if (StringUtils.isNotEmpty((CharSequence)tableAlias)) {
            return new Column("%s.%s".formatted(tableAlias, columnName));
        }
        return new Column(columnName);
    }
}

