/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.handler.datasource;

import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import top.continew.starter.extension.tenant.handler.datasource.TenantDataSourceInterceptor;

public class TenantDataSourceAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;

    public TenantDataSourceAdvisor(TenantDataSourceInterceptor interceptor) {
        this.advice = interceptor;
        this.pointcut = this.buildPointcut();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Advice advice = this.advice;
        if (advice instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAware = (BeanFactoryAware)advice;
            beanFactoryAware.setBeanFactory(beanFactory);
        }
    }

    private Pointcut buildPointcut() {
        AspectJExpressionPointcut cut = new AspectJExpressionPointcut();
        cut.setExpression("execution(* *..controller..*(..))\n");
        return new ComposablePointcut((Pointcut)cut);
    }
}

