/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.handler.datasource;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import top.continew.starter.extension.tenant.TenantDataSourceHandler;
import top.continew.starter.extension.tenant.context.TenantContextHolder;
import top.continew.starter.extension.tenant.enums.TenantIsolationLevel;

public class TenantDataSourceInterceptor
implements MethodInterceptor {
    private final TenantDataSourceHandler tenantDataSourceHandler;

    public TenantDataSourceInterceptor(TenantDataSourceHandler tenantDataSourceHandler) {
        this.tenantDataSourceHandler = tenantDataSourceHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (TenantContextHolder.isIgnore()) {
            return true;
        }
        if (TenantIsolationLevel.LINE.equals((Object)TenantContextHolder.getIsolationLevel())) {
            return invocation.proceed();
        }
        boolean isPush = false;
        try {
            this.tenantDataSourceHandler.changeDataSource(TenantContextHolder.getDataSource());
            isPush = true;
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (isPush) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }
}

