/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.json.jackson.serializer;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import top.continew.starter.core.enums.BaseEnum;

@JacksonStdImpl
public class BaseEnumDeserializer
extends JsonDeserializer<BaseEnum> {
    public static final BaseEnumDeserializer SERIALIZER_INSTANCE = new BaseEnumDeserializer();

    public BaseEnum deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Class<?> targetClass = jsonParser.getCurrentValue().getClass();
        String fieldName = jsonParser.getCurrentName();
        String value = jsonParser.getText();
        return this.getEnum(targetClass, value, fieldName);
    }

    private BaseEnum getEnum(Class<?> targetClass, String value, String fieldName) {
        ?[] enumConstants;
        Field field = ReflectUtil.getField(targetClass, (String)fieldName);
        Class<?> fieldTypeClass = field.getType();
        for (Object enumConstant : enumConstants = fieldTypeClass.getEnumConstants()) {
            BaseEnum baseEnum;
            if (!ClassUtil.isAssignable(BaseEnum.class, fieldTypeClass) || !Objects.equals(Convert.toStr((Object)(baseEnum = (BaseEnum)enumConstant).getValue()), Convert.toStr((Object)value))) continue;
            return baseEnum;
        }
        return null;
    }
}

