/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.messaging.mail.core;

import cn.hutool.core.map.MapUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import top.continew.starter.core.util.validation.ValidationUtils;

public class MailConfig {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PROTOCOL = "smtp";
    private String protocol = "smtp";
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String from;
    private boolean sslEnabled = false;
    private Integer sslPort;
    private Charset defaultEncoding = DEFAULT_CHARSET;
    private final Map<String, String> properties = MapUtil.newHashMap();

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Integer getSslPort() {
        return this.sslPort;
    }

    public void setSslPort(Integer sslPort) {
        this.sslPort = sslPort;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(Charset defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Properties toJavaMailProperties() {
        Properties javaMailProperties = new Properties();
        javaMailProperties.putAll(this.getProperties());
        javaMailProperties.put("mail.from", this.getFrom());
        javaMailProperties.put("mail.smtp.auth", (Object)true);
        javaMailProperties.put("mail.smtp.ssl.enable", (Object)this.isSslEnabled());
        if (this.isSslEnabled()) {
            ValidationUtils.throwIfNull((Object)this.getSslPort(), (String)"\u90ae\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e\uff1aSSL\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            javaMailProperties.put("mail.smtp.socketFactory.port", this.sslPort);
            javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        return javaMailProperties;
    }
}

