/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.autoconfigure;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import top.continew.starter.core.util.GeneralPropertySourceFactory;
import top.continew.starter.core.util.validation.CheckUtils;
import top.continew.starter.security.crypto.autoconfigure.CryptoProperties;
import top.continew.starter.security.crypto.autoconfigure.PasswordEncoderProperties;
import top.continew.starter.security.crypto.enums.PasswordEncoderAlgorithm;
import top.continew.starter.security.crypto.mybatis.MyBatisDecryptInterceptor;
import top.continew.starter.security.crypto.mybatis.MyBatisEncryptInterceptor;
import top.continew.starter.security.crypto.util.EncryptHelper;
import top.continew.starter.security.crypto.util.PasswordEncoderUtil;

@AutoConfiguration
@EnableConfigurationProperties(value={CryptoProperties.class})
@ConditionalOnProperty(prefix="continew-starter.security.crypto", name={"enabled"}, havingValue="true", matchIfMissing=true)
@PropertySource(value={"classpath:default-crypto.yml"}, factory=GeneralPropertySourceFactory.class)
public class CryptoAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CryptoAutoConfiguration.class);
    private final CryptoProperties properties;

    public CryptoAutoConfiguration(CryptoProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MyBatisEncryptInterceptor mybatisEncryptInterceptor() {
        return new MyBatisEncryptInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={MyBatisDecryptInterceptor.class})
    public MyBatisDecryptInterceptor mybatisDecryptInterceptor() {
        return new MyBatisDecryptInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="continew-starter.security.crypto.password-encoder", name={"enabled"}, havingValue="true")
    public PasswordEncoder passwordEncoder() {
        PasswordEncoderProperties passwordEncoderProperties = this.properties.getPasswordEncoder();
        HashMap<String, PasswordEncoder> encoders = new HashMap<String, PasswordEncoder>();
        encoders.put(PasswordEncoderAlgorithm.BCRYPT.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.BCRYPT));
        encoders.put(PasswordEncoderAlgorithm.SCRYPT.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.SCRYPT));
        encoders.put(PasswordEncoderAlgorithm.PBKDF2.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.PBKDF2));
        encoders.put(PasswordEncoderAlgorithm.ARGON2.name().toLowerCase(), PasswordEncoderUtil.getEncoder(PasswordEncoderAlgorithm.ARGON2));
        PasswordEncoderAlgorithm algorithm = passwordEncoderProperties.getAlgorithm();
        CheckUtils.throwIf((PasswordEncoderUtil.getEncoder(algorithm) == null ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5: {}", (Object[])new Object[]{algorithm});
        return new DelegatingPasswordEncoder(algorithm.name().toLowerCase(), encoders);
    }

    @PostConstruct
    public void postConstruct() {
        EncryptHelper.init(this.properties);
        log.debug("[ContiNew Starter] - Auto Configuration 'Security-Crypto' completed initialization.");
    }
}

