/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.encryptor;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.continew.starter.security.crypto.autoconfigure.CryptoContext;
import top.continew.starter.security.crypto.encryptor.AbstractEncryptor;

public abstract class AbstractSymmetricCryptoEncryptor
extends AbstractEncryptor {
    private static final Map<String, SymmetricCrypto> CACHE = new ConcurrentHashMap<String, SymmetricCrypto>();
    private final CryptoContext context;

    protected AbstractSymmetricCryptoEncryptor(CryptoContext context) {
        super(context);
        this.context = context;
    }

    @Override
    public String encrypt(String plaintext) {
        if (CharSequenceUtil.isBlank((CharSequence)plaintext)) {
            return plaintext;
        }
        return this.getCrypto(this.context.getPassword()).encryptHex(plaintext);
    }

    @Override
    public String decrypt(String ciphertext) {
        if (CharSequenceUtil.isBlank((CharSequence)ciphertext)) {
            return ciphertext;
        }
        return this.getCrypto(this.context.getPassword()).decryptStr(ciphertext);
    }

    protected SymmetricCrypto getCrypto(String password) {
        SymmetricAlgorithm algorithm = this.getAlgorithm();
        String key = algorithm + "_" + password;
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        SymmetricCrypto symmetricCrypto = new SymmetricCrypto(algorithm, password.getBytes(StandardCharsets.UTF_8));
        CACHE.put(key, symmetricCrypto);
        return symmetricCrypto;
    }

    protected abstract SymmetricAlgorithm getAlgorithm();
}

