/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.encryptor;

import cn.hutool.extra.spring.SpringUtil;
import org.springframework.security.crypto.password.PasswordEncoder;
import top.continew.starter.security.crypto.autoconfigure.CryptoContext;
import top.continew.starter.security.crypto.autoconfigure.CryptoProperties;
import top.continew.starter.security.crypto.encryptor.AbstractEncryptor;

public class PasswordEncoderEncryptor
extends AbstractEncryptor {
    private final PasswordEncoder passwordEncoder = (PasswordEncoder)SpringUtil.getBean(PasswordEncoder.class);
    private final CryptoProperties properties = (CryptoProperties)SpringUtil.getBean(CryptoProperties.class);

    public PasswordEncoderEncryptor(CryptoContext context) {
        super(context);
    }

    @Override
    public String encrypt(String plaintext) {
        if (this.properties.getPasswordEncoder().getAlgorithm().getPattern().matcher(plaintext).matches()) {
            return plaintext;
        }
        return this.passwordEncoder.encode((CharSequence)plaintext);
    }

    @Override
    public String decrypt(String ciphertext) {
        return ciphertext;
    }
}

