/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.mybatis;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.MappedStatement;
import top.continew.starter.core.exception.BaseException;
import top.continew.starter.security.crypto.annotation.FieldEncrypt;

public abstract class AbstractMyBatisInterceptor {
    private static final Map<Class<?>, List<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<String, Map<String, FieldEncrypt>> ENCRYPT_PARAM_CACHE = new ConcurrentHashMap<String, Map<String, FieldEncrypt>>();

    protected List<Field> getEncryptFields(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        return this.getEncryptFields(obj.getClass());
    }

    protected List<Field> getEncryptFields(Class<?> clazz) {
        return CLASS_FIELD_CACHE.computeIfAbsent(clazz, key -> Arrays.stream(ReflectUtil.getFields((Class)clazz)).filter(field -> String.class.equals(field.getType())).filter(field -> field.getAnnotation(FieldEncrypt.class) != null).toList());
    }

    protected Map<String, FieldEncrypt> getEncryptParameters(MappedStatement mappedStatement) {
        String mappedStatementId = mappedStatement.getId();
        return ENCRYPT_PARAM_CACHE.computeIfAbsent(mappedStatementId, key -> {
            Method method = this.getMethod(mappedStatementId);
            if (method == null) {
                return Collections.emptyMap();
            }
            HashMap<Object, FieldEncrypt> encryptMap = new HashMap<Object, FieldEncrypt>();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                FieldEncrypt fieldEncrypt = parameter.getAnnotation(FieldEncrypt.class);
                if (fieldEncrypt == null) continue;
                String parameterName = this.getParameterName(parameter);
                encryptMap.put(parameterName, fieldEncrypt);
                if (!String.class.equals(parameter.getType())) continue;
                encryptMap.put("param" + (i + 1), fieldEncrypt);
            }
            return encryptMap;
        });
    }

    private Method getMethod(String mappedStatementId) {
        String className = CharSequenceUtil.subBefore((CharSequence)mappedStatementId, (CharSequence)".", (boolean)true);
        String methodName = CharSequenceUtil.subAfter((CharSequence)mappedStatementId, (CharSequence)".", (boolean)true);
        try {
            Method[] methods = ReflectUtil.getMethods(Class.forName(className));
            return Stream.of(methods).filter(method -> method.getName().equals(methodName)).findFirst().orElse(null);
        }
        catch (ClassNotFoundException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String getParameterName(Parameter parameter) {
        Param param = parameter.getAnnotation(Param.class);
        return param != null ? param.value() : parameter.getName();
    }
}

