/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.type.SimpleTypeRegistry;
import top.continew.starter.security.crypto.annotation.FieldEncrypt;
import top.continew.starter.security.crypto.mybatis.AbstractMyBatisInterceptor;
import top.continew.starter.security.crypto.util.EncryptHelper;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class MyBatisDecryptInterceptor
extends AbstractMyBatisInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object obj = invocation.proceed();
        if (ObjectUtil.isNull((Object)obj)) {
            return null;
        }
        if (!(invocation.getTarget() instanceof ResultSetHandler)) {
            return obj;
        }
        if (obj instanceof List) {
            List resultList = (List)obj;
            this.decryptList(resultList);
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            this.decryptMap(map);
        } else {
            this.decryptObject(obj);
        }
        return obj;
    }

    private void decryptList(List<?> resultList) {
        if (CollUtil.isEmpty(resultList)) {
            return;
        }
        for (Object result : resultList) {
            this.decryptObject(result);
        }
    }

    private void decryptMap(Map<?, ?> resultMap) {
        if (CollUtil.isEmpty(resultMap)) {
            return;
        }
        new HashSet(resultMap.values()).forEach(this::decryptObject);
    }

    private void decryptObject(Object result) {
        if (ObjectUtil.isNull((Object)result)) {
            return;
        }
        if (SimpleTypeRegistry.isSimpleType(result.getClass())) {
            return;
        }
        List<Field> fieldList = super.getEncryptFields(result);
        if (fieldList.isEmpty()) {
            return;
        }
        for (Field field : fieldList) {
            String strValue;
            Object fieldValue = ReflectUtil.getFieldValue((Object)result, (Field)field);
            if (fieldValue == null || CharSequenceUtil.isBlank((CharSequence)(strValue = String.valueOf(fieldValue)))) continue;
            ReflectUtil.setFieldValue((Object)result, (Field)field, (Object)EncryptHelper.decrypt(strValue, field.getAnnotation(FieldEncrypt.class)));
        }
    }
}

