/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.security.crypto.mybatis;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import top.continew.starter.security.crypto.annotation.FieldEncrypt;
import top.continew.starter.security.crypto.mybatis.AbstractMyBatisInterceptor;
import top.continew.starter.security.crypto.util.EncryptHelper;

public class MyBatisEncryptInterceptor
extends AbstractMyBatisInterceptor
implements InnerInterceptor {
    private static final Pattern PARAM_PAIRS_PATTERN = Pattern.compile("#\\{ew\\.paramNameValuePairs\\.(MPGENVAL\\d+)\\}");

    public void beforeQuery(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (parameterObject == null) {
            return;
        }
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            this.encryptQueryParameter(parameterMap, mappedStatement);
        }
    }

    public void beforeUpdate(Executor executor, MappedStatement mappedStatement, Object parameterObject) {
        if (parameterObject == null) {
            return;
        }
        if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            this.encryptMap(parameterMap, mappedStatement);
        } else {
            this.encryptEntity(super.getEncryptFields(parameterObject), parameterObject);
        }
    }

    private void encryptQueryParameter(Map<String, Object> parameterMap, MappedStatement mappedStatement) {
        Map<String, FieldEncrypt> encryptParameterMap = super.getEncryptParameters(mappedStatement);
        for (Map.Entry<String, Object> parameterEntrySet : parameterMap.entrySet()) {
            String parameterName = parameterEntrySet.getKey();
            Object parameterValue = parameterEntrySet.getValue();
            if (parameterValue == null || ClassUtil.isBasicType(parameterValue.getClass()) || parameterValue instanceof AbstractWrapper) continue;
            if (parameterValue instanceof String) {
                String str = (String)parameterValue;
                FieldEncrypt fieldEncrypt = encryptParameterMap.get(parameterName);
                if (fieldEncrypt == null) continue;
                parameterMap.put(parameterName, this.doEncrypt(str, fieldEncrypt));
                continue;
            }
            this.encryptEntity(super.getEncryptFields(parameterValue), parameterValue);
        }
    }

    private void encryptEntity(List<Field> fieldList, Object entity) {
        for (Field field : fieldList) {
            String strValue;
            Object fieldValue = ReflectUtil.getFieldValue((Object)entity, (Field)field);
            if (fieldValue == null || CharSequenceUtil.isBlank((CharSequence)(strValue = String.valueOf(fieldValue)))) continue;
            ReflectUtil.setFieldValue((Object)entity, (Field)field, (Object)EncryptHelper.encrypt(strValue, field.getAnnotation(FieldEncrypt.class)));
        }
    }

    private void encryptMap(Map<String, Object> parameterMap, MappedStatement mappedStatement) {
        Object parameter;
        if (parameterMap.containsKey("et") && (parameter = parameterMap.get("et")) != null) {
            this.encryptEntity(super.getEncryptFields(parameter), parameter);
        }
        if (parameterMap.containsKey("ew") && (parameter = parameterMap.get("ew")) != null) {
            this.encryptUpdateWrapper(parameter, mappedStatement);
        }
    }

    private void encryptUpdateWrapper(Object parameter, MappedStatement mappedStatement) {
        if (parameter instanceof AbstractWrapper) {
            AbstractWrapper updateWrapper = (AbstractWrapper)parameter;
            String sqlSet = updateWrapper.getSqlSet();
            if (CharSequenceUtil.isBlank((CharSequence)sqlSet)) {
                return;
            }
            String[] elArr = sqlSet.split(",");
            HashMap propMap = new HashMap(elArr.length);
            Arrays.stream(elArr).forEach(el -> {
                String[] elPart = el.split("=");
                propMap.put(elPart[0], elPart[1]);
            });
            Class<?> entityClass = this.getEntityClass(updateWrapper, mappedStatement);
            List<Field> encryptFieldList = super.getEncryptFields(entityClass);
            for (Field field : encryptFieldList) {
                Matcher matcher;
                FieldEncrypt fieldEncrypt = field.getAnnotation(FieldEncrypt.class);
                String el2 = (String)propMap.get(field.getName());
                if (CharSequenceUtil.isBlank((CharSequence)el2) || !(matcher = PARAM_PAIRS_PATTERN.matcher(el2)).matches()) continue;
                String valueKey = matcher.group(1);
                Object value = updateWrapper.getParamNameValuePairs().get(valueKey);
                updateWrapper.getParamNameValuePairs().put(valueKey, this.doEncrypt(value, fieldEncrypt));
            }
        }
    }

    private Object doEncrypt(Object parameterValue, FieldEncrypt fieldEncrypt) {
        if (ObjectUtil.isNull((Object)parameterValue)) {
            return null;
        }
        String strValue = String.valueOf(parameterValue);
        if (CharSequenceUtil.isBlank((CharSequence)strValue)) {
            return null;
        }
        return EncryptHelper.encrypt(strValue, fieldEncrypt);
    }

    private Class<?> getEntityClass(AbstractWrapper wrapper, MappedStatement mappedStatement) {
        Class entityClass = wrapper.getEntityClass();
        if (entityClass != null) {
            return entityClass;
        }
        return mappedStatement.getParameterMap().getType();
    }
}

