/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.web.autoconfigure.cors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import top.continew.starter.web.autoconfigure.cors.CorsProperties;

@Lazy
@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="continew-starter.web.cors", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CorsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CorsFilter corsFilter(CorsProperties properties) {
        CorsConfiguration config = new CorsConfiguration();
        config.setMaxAge(Long.valueOf(1800L));
        if (properties.getAllowedOrigins().contains("*")) {
            config.addAllowedOriginPattern("*");
        } else {
            config.setAllowCredentials(Boolean.valueOf(true));
            properties.getAllowedOrigins().forEach(arg_0 -> ((CorsConfiguration)config).addAllowedOrigin(arg_0));
        }
        properties.getAllowedMethods().forEach(arg_0 -> ((CorsConfiguration)config).addAllowedMethod(arg_0));
        properties.getAllowedHeaders().forEach(arg_0 -> ((CorsConfiguration)config).addAllowedHeader(arg_0));
        properties.getExposedHeaders().forEach(arg_0 -> ((CorsConfiguration)config).addExposedHeader(arg_0));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        CorsFilter corsFilter = new CorsFilter((CorsConfigurationSource)source);
        log.debug("[ContiNew Starter] - Auto Configuration 'Web-CorsFilter' completed initialization.");
        return corsFilter;
    }
}

