/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.footer;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

class XEasyPdfFooterParam {
    private String text;
    private List<String> splitTextList;
    private String fontPath;
    private PDFont font;
    private Float fontSize = Float.valueOf(10.0f);
    private Float leading = Float.valueOf(1.0f);
    private Color fontColor = Color.BLACK;
    private XEasyPdfTextStyle style = XEasyPdfTextStyle.CENTER;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(5.0f);
    private Float beginX;
    private Float beginY;
    private Float height;

    void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath);
        }
        if (this.splitTextList == null) {
            this.splitTextList = XEasyPdfTextUtil.splitLines(this.text, page.getLastPage().getMediaBox().getWidth() - this.marginLeft.floatValue() - this.marginRight.floatValue(), this.font, this.fontSize.floatValue());
        }
        this.beginX = this.marginLeft;
        this.height = this.beginY = Float.valueOf(this.marginBottom.floatValue() + this.fontSize.floatValue() * (float)(this.splitTextList.size() - 1));
    }

    public String getText() {
        return this.text;
    }

    public List<String> getSplitTextList() {
        return this.splitTextList;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Float getLeading() {
        return this.leading;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public XEasyPdfTextStyle getStyle() {
        return this.style;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getHeight() {
        return this.height;
    }

    public XEasyPdfFooterParam setText(String text) {
        this.text = text;
        return this;
    }

    public XEasyPdfFooterParam setSplitTextList(List<String> splitTextList) {
        this.splitTextList = splitTextList;
        return this;
    }

    public XEasyPdfFooterParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfFooterParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfFooterParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfFooterParam setLeading(Float leading) {
        this.leading = leading;
        return this;
    }

    public XEasyPdfFooterParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfFooterParam setStyle(XEasyPdfTextStyle style) {
        this.style = style;
        return this;
    }

    public XEasyPdfFooterParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfFooterParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfFooterParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfFooterParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfFooterParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfFooterParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfFooterParam)) {
            return false;
        }
        XEasyPdfFooterParam other = (XEasyPdfFooterParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$splitTextList = this.getSplitTextList();
        List<String> other$splitTextList = other.getSplitTextList();
        if (this$splitTextList == null ? other$splitTextList != null : !((Object)this$splitTextList).equals(other$splitTextList)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        XEasyPdfTextStyle this$style = this.getStyle();
        XEasyPdfTextStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        return !(this$height == null ? other$height != null : !((Object)this$height).equals(other$height));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfFooterParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $splitTextList = this.getSplitTextList();
        result = result * 59 + ($splitTextList == null ? 43 : ((Object)$splitTextList).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        XEasyPdfTextStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfFooterParam(text=" + this.getText() + ", splitTextList=" + this.getSplitTextList() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", leading=" + this.getLeading() + ", fontColor=" + this.getFontColor() + ", style=" + (Object)((Object)this.getStyle()) + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginBottom=" + this.getMarginBottom() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", height=" + this.getHeight() + ")";
    }
}

