/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.header;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.component.header.XEasyPdfHeaderParam;
import wiki.xsx.core.pdf.component.line.XEasyPdfSolidSplitLine;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfDefaultHeader
implements XEasyPdfHeader {
    private final XEasyPdfHeaderParam param = new XEasyPdfHeaderParam();

    public XEasyPdfDefaultHeader(String text) {
        this.param.setText(text);
    }

    public XEasyPdfDefaultHeader(float fontSize, String text) {
        this.param.setText(text);
    }

    public XEasyPdfDefaultHeader setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDefaultHeader setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDefaultHeader setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDefaultHeader setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDefaultHeader setLeading(float leading) {
        if (leading > 0.0f) {
            this.param.setLeading(Float.valueOf(leading));
        }
        return this;
    }

    public XEasyPdfDefaultHeader setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfDefaultHeader setFont(PDFont font) {
        this.param.setFont(font);
        return this;
    }

    public XEasyPdfDefaultHeader setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfDefaultHeader setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfDefaultHeader setStyle(XEasyPdfTextStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public XEasyPdfDefaultHeader setSplitTextList(List<String> splitTextList) {
        this.param.setSplitTextList(splitTextList);
        return this;
    }

    public XEasyPdfDefaultHeader setHasSplitLine(boolean hasSplitLine) {
        this.param.setHasSplitLine(hasSplitLine);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        new XEasyPdfText(this.param.getText()).setFontPath(this.param.getFontPath()).setFont(this.param.getFont()).setFontSize(this.param.getFontSize().floatValue()).setLeading(this.param.getLeading().floatValue()).setFontColor(this.param.getFontColor()).setMarginLeft(this.param.getMarginLeft().floatValue()).setMarginRight(this.param.getMarginRight().floatValue()).setMarginTop(this.param.getMarginTop().floatValue()).setSplitTextList(this.param.getSplitTextList()).setStyle(this.param.getStyle()).draw(document, page);
        if (this.param.isHasSplitLine()) {
            float margin = 5.0f;
            new XEasyPdfSolidSplitLine().setFontPath(this.param.getFontPath()).setFont(this.param.getFont()).setMarginLeft(margin).setMarginRight(margin).draw(document, page);
            new XEasyPdfSolidSplitLine().setFontPath(this.param.getFontPath()).setFont(this.param.getFont()).setMarginTop(1.0f).setMarginLeft(margin).setMarginRight(margin).draw(document, page);
        }
    }
}

