/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfLine
implements XEasyPdfComponent {
    private XEasyPdfLineParam param = new XEasyPdfLineParam();

    public XEasyPdfLine(XEasyPdfLineParam param) {
        this.param = param;
    }

    public XEasyPdfLine(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
    }

    public XEasyPdfLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfLine setFont(PDFont font) {
        this.param.setFont(font);
        return this;
    }

    public XEasyPdfLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(lineWidth));
        return this;
    }

    public XEasyPdfLine setColor(Color color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        this.param.setStyle(lineCapStyle);
        return this;
    }

    public XEasyPdfLine setPosition(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfLine setPosition(float beginX, float beginY) {
        return this;
    }

    @Override
    public XEasyPdfLine setWidth(float width) {
        this.param.setEndX(Float.valueOf(this.param.getBeginX().floatValue() + width));
        return this;
    }

    @Override
    public XEasyPdfLine setHeight(float height) {
        this.param.setEndY(Float.valueOf(this.param.getBeginY().floatValue() - height));
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (this.param.getBeginX() == null || this.param.getBeginY() == null || this.param.getEndX() == null || this.param.getEndY() == null) {
            throw new RuntimeException("beginX or beginY or endX or endY can not null");
        }
        if (this.param.getFont() == null) {
            this.param.setFont(XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath()));
        }
        PDPageContentStream contentStream = this.initStream(document, page);
        contentStream.moveTo(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue());
        contentStream.setStrokingColor(this.param.getColor());
        contentStream.lineTo(this.param.getEndX().floatValue(), this.param.getEndY().floatValue());
        contentStream.stroke();
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.close();
        this.param.setDraw(true);
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    private PDPageContentStream initStream(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), PDPageContentStream.AppendMode.APPEND, true, false);
        contentStream.setFont(this.param.getFont(), this.param.getFontSize().floatValue());
        contentStream.setLineWidth(this.param.getLineWidth().floatValue());
        contentStream.setLineCapStyle(this.param.getStyle().getType());
        return contentStream;
    }
}

