/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfSolidSplitLine
implements XEasyPdfComponent {
    private final XEasyPdfLineParam param = new XEasyPdfLineParam();

    public XEasyPdfSolidSplitLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfSolidSplitLine setFont(PDFont font) {
        this.param.setFont(font);
        return this;
    }

    public XEasyPdfSolidSplitLine setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(lineWidth));
        return this;
    }

    public XEasyPdfSolidSplitLine setColor(Color color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfSolidSplitLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        this.param.setStyle(lineCapStyle);
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setPosition(float beginX, float beginY) {
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setWidth(float width) {
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setHeight(float height) {
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.init(document, page);
        new XEasyPdfLine(this.param).draw(document, page);
        if (page.getParam().isAllowResetPosition()) {
            page.getParam().setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getLineWidth().floatValue() / 2.0f));
        }
        this.param.setDraw(true);
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.param.checkPage(document, page);
        float lineWidth = this.param.getLineWidth().floatValue() / 2.0f;
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        this.param.setBeginX(this.param.getMarginLeft()).setBeginY(Float.valueOf(page.getParam().getPageY() == null ? rectangle.getHeight() - this.param.getMarginTop().floatValue() - lineWidth : page.getParam().getPageY().floatValue() - this.param.getMarginTop().floatValue() - lineWidth)).setEndX(Float.valueOf(rectangle.getWidth() - this.param.getMarginRight().floatValue())).setEndY(this.param.getBeginY());
        if (this.param.getFont() == null) {
            this.param.setFont(XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath()));
        }
    }
}

