/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.mark;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import wiki.xsx.core.pdf.component.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.component.mark.XEasyPdfWatermarkParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfDefaultWatermark
implements XEasyPdfWatermark {
    private final XEasyPdfWatermarkParam param = new XEasyPdfWatermarkParam();

    public XEasyPdfDefaultWatermark(String text) {
        this.param.setText(text);
    }

    public XEasyPdfDefaultWatermark(float fontSize, String text) {
        this.param.setFontSize(Float.valueOf(fontSize)).setText(text);
    }

    public XEasyPdfDefaultWatermark setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfDefaultWatermark setFont(PDFont font) {
        this.param.setFont(font);
        return this;
    }

    public XEasyPdfDefaultWatermark setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfDefaultWatermark setAlpha(float alpha) {
        this.param.setAlpha(Float.valueOf(alpha));
        return this;
    }

    public XEasyPdfDefaultWatermark setRadians(double radians) {
        this.param.setRadians(radians);
        return this;
    }

    public XEasyPdfDefaultWatermark setText(String text) {
        this.param.setText(text);
        return this;
    }

    public XEasyPdfDefaultWatermark setWordSpace(float wordSpace) {
        this.param.setWordSpace(Float.valueOf(wordSpace));
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDExtendedGraphicsState state = this.param.init(document, page);
        List<PDPage> pageList = page.getParam().getPageList();
        for (PDPage pdPage : pageList) {
            this.doDraw(document, pdPage, state);
        }
        pageList = page.getParam().getNewPageList();
        for (PDPage pdPage : pageList) {
            this.doDraw(document, pdPage, state);
        }
    }

    private void doDraw(XEasyPdfDocument document, PDPage pdPage, PDExtendedGraphicsState state) throws IOException {
        int count = 11;
        float color = 0.3f;
        float beginX = 0.0f;
        float beginY = 0.0f;
        PDPageContentStream cs = new PDPageContentStream(document.getTarget(), pdPage, PDPageContentStream.AppendMode.APPEND, true, true);
        cs.setGraphicsStateParameters(state);
        cs.setNonStrokingColor(color);
        for (int i = 0; i < count; ++i) {
            this.writeText(cs, beginX, beginY);
            for (int j = 0; j < count; ++j) {
                this.writeText(cs, beginX += this.param.getWordSpace().floatValue(), beginY);
            }
            beginX = 0.0f;
            beginY += this.param.getWordSpace().floatValue();
        }
        cs.close();
    }

    private void writeText(PDPageContentStream cs, float beginX, float beginY) throws IOException {
        cs.beginText();
        cs.setFont(this.param.getFont(), this.param.getFontSize().floatValue());
        cs.setTextMatrix(Matrix.getRotateInstance((double)this.param.getRadians(), (float)beginX, (float)beginY));
        cs.showText(this.param.getText());
        cs.endText();
    }
}

