/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfRowParam;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

class XEasyPdfCellParam {
    private boolean hasBorder = true;
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Float width;
    private Float height;
    private String text;
    private List<String> splitTextList;
    private String fontPath;
    private PDFont font;
    private Float fontSize;
    private Color fontColor = Color.BLACK;
    private float lineWidth = 1.0f;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float textMarginLeft;
    private Float textMarginRight;
    private Float textMarginTop = Float.valueOf(0.0f);
    private Float textMarginBottom = Float.valueOf(0.0f);
    private XEasyPdfTextStyle style;

    void init(XEasyPdfDocument document, XEasyPdfRow row) throws IOException {
        XEasyPdfRowParam rowParam = row.getParam();
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.getFont(document, this.fontPath, rowParam.getFont());
        }
        if (this.fontSize == null) {
            this.fontSize = rowParam.getFontSize();
        }
        if (this.style == null) {
            this.style = rowParam.getStyle();
        }
        if (this.textMarginLeft == null) {
            this.textMarginLeft = Float.valueOf(2.0f);
        }
        if (this.textMarginRight == null) {
            this.textMarginRight = Float.valueOf(2.0f);
        }
        if (this.text != null && this.text.trim().length() > 0) {
            if (this.width == null) {
                this.textMarginLeft = Float.valueOf(2.0f);
                this.textMarginRight = Float.valueOf(2.0f);
                this.width = Float.valueOf(this.fontSize.floatValue() * this.font.getStringWidth(this.text) / 1000.0f + this.textMarginLeft.floatValue() + this.textMarginRight.floatValue());
                this.splitTextList = new ArrayList<String>(1);
                this.splitTextList.add(this.text);
            } else {
                this.splitTextList = XEasyPdfTextUtil.splitLines(this.text, this.width.floatValue() - this.textMarginLeft.floatValue() - this.textMarginRight.floatValue(), this.font, this.fontSize.floatValue());
            }
        } else {
            this.splitTextList = new ArrayList<String>(0);
            if (this.width == null) {
                this.width = Float.valueOf(0.0f);
                this.height = Float.valueOf(0.0f);
            }
        }
        if (this.height == null) {
            this.textMarginTop = Float.valueOf(5.0f);
            this.height = Float.valueOf(this.fontSize.floatValue() * (float)this.splitTextList.size() + this.textMarginTop.floatValue() + this.textMarginBottom.floatValue());
        }
    }

    public boolean isHasBorder() {
        return this.hasBorder;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getSplitTextList() {
        return this.splitTextList;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getTextMarginLeft() {
        return this.textMarginLeft;
    }

    public Float getTextMarginRight() {
        return this.textMarginRight;
    }

    public Float getTextMarginTop() {
        return this.textMarginTop;
    }

    public Float getTextMarginBottom() {
        return this.textMarginBottom;
    }

    public XEasyPdfTextStyle getStyle() {
        return this.style;
    }

    public XEasyPdfCellParam setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfCellParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfCellParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfCellParam setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfCellParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfCellParam setText(String text) {
        this.text = text;
        return this;
    }

    public XEasyPdfCellParam setSplitTextList(List<String> splitTextList) {
        this.splitTextList = splitTextList;
        return this;
    }

    public XEasyPdfCellParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfCellParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfCellParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfCellParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfCellParam setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public XEasyPdfCellParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfCellParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfCellParam setTextMarginLeft(Float textMarginLeft) {
        this.textMarginLeft = textMarginLeft;
        return this;
    }

    public XEasyPdfCellParam setTextMarginRight(Float textMarginRight) {
        this.textMarginRight = textMarginRight;
        return this;
    }

    public XEasyPdfCellParam setTextMarginTop(Float textMarginTop) {
        this.textMarginTop = textMarginTop;
        return this;
    }

    public XEasyPdfCellParam setTextMarginBottom(Float textMarginBottom) {
        this.textMarginBottom = textMarginBottom;
        return this;
    }

    public XEasyPdfCellParam setStyle(XEasyPdfTextStyle style) {
        this.style = style;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfCellParam)) {
            return false;
        }
        XEasyPdfCellParam other = (XEasyPdfCellParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasBorder() != other.isHasBorder()) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$splitTextList = this.getSplitTextList();
        List<String> other$splitTextList = other.getSplitTextList();
        if (this$splitTextList == null ? other$splitTextList != null : !((Object)this$splitTextList).equals(other$splitTextList)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        if (Float.compare(this.getLineWidth(), other.getLineWidth()) != 0) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$textMarginLeft = this.getTextMarginLeft();
        Float other$textMarginLeft = other.getTextMarginLeft();
        if (this$textMarginLeft == null ? other$textMarginLeft != null : !((Object)this$textMarginLeft).equals(other$textMarginLeft)) {
            return false;
        }
        Float this$textMarginRight = this.getTextMarginRight();
        Float other$textMarginRight = other.getTextMarginRight();
        if (this$textMarginRight == null ? other$textMarginRight != null : !((Object)this$textMarginRight).equals(other$textMarginRight)) {
            return false;
        }
        Float this$textMarginTop = this.getTextMarginTop();
        Float other$textMarginTop = other.getTextMarginTop();
        if (this$textMarginTop == null ? other$textMarginTop != null : !((Object)this$textMarginTop).equals(other$textMarginTop)) {
            return false;
        }
        Float this$textMarginBottom = this.getTextMarginBottom();
        Float other$textMarginBottom = other.getTextMarginBottom();
        if (this$textMarginBottom == null ? other$textMarginBottom != null : !((Object)this$textMarginBottom).equals(other$textMarginBottom)) {
            return false;
        }
        XEasyPdfTextStyle this$style = this.getStyle();
        XEasyPdfTextStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfCellParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasBorder() ? 79 : 97);
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $splitTextList = this.getSplitTextList();
        result = result * 59 + ($splitTextList == null ? 43 : ((Object)$splitTextList).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getLineWidth());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $textMarginLeft = this.getTextMarginLeft();
        result = result * 59 + ($textMarginLeft == null ? 43 : ((Object)$textMarginLeft).hashCode());
        Float $textMarginRight = this.getTextMarginRight();
        result = result * 59 + ($textMarginRight == null ? 43 : ((Object)$textMarginRight).hashCode());
        Float $textMarginTop = this.getTextMarginTop();
        result = result * 59 + ($textMarginTop == null ? 43 : ((Object)$textMarginTop).hashCode());
        Float $textMarginBottom = this.getTextMarginBottom();
        result = result * 59 + ($textMarginBottom == null ? 43 : ((Object)$textMarginBottom).hashCode());
        XEasyPdfTextStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfCellParam(hasBorder=" + this.isHasBorder() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", text=" + this.getText() + ", splitTextList=" + this.getSplitTextList() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", lineWidth=" + this.getLineWidth() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", textMarginLeft=" + this.getTextMarginLeft() + ", textMarginRight=" + this.getTextMarginRight() + ", textMarginTop=" + this.getTextMarginTop() + ", textMarginBottom=" + this.getTextMarginBottom() + ", style=" + (Object)((Object)this.getStyle()) + ")";
    }
}

