/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRowParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfRow {
    private final XEasyPdfRowParam param = new XEasyPdfRowParam();

    public XEasyPdfRow(XEasyPdfCell ... cells) {
        Collections.addAll(this.param.getCells(), cells);
    }

    public XEasyPdfRow(List<XEasyPdfCell> cellList) {
        this.param.getCells().addAll(cellList);
    }

    public XEasyPdfRow addCell(XEasyPdfCell ... cells) {
        Collections.addAll(this.param.getCells(), cells);
        return this;
    }

    public XEasyPdfRow addCell(List<XEasyPdfCell> cellList) {
        this.param.getCells().addAll(cellList);
        return this;
    }

    public XEasyPdfRow setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfRow setFont(PDFont font) {
        this.param.setFont(font);
        return this;
    }

    public XEasyPdfRow setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfRow setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRow setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRow setStyle(XEasyPdfTextStyle style) {
        this.param.setStyle(style);
        return this;
    }

    XEasyPdfRowParam getParam() {
        return this.param;
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table) throws IOException {
        this.param.init(document, page, table, this);
        List<XEasyPdfCell> cells = this.param.getCells();
        for (XEasyPdfCell cell : cells) {
            if (cell == null) continue;
            cell.doDraw(document, page, this);
            this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getMarginLeft().floatValue() + cell.getParam().getWidth().floatValue() - 1.0f));
        }
        page.getParam().setPageY(this.param.getBeginY());
    }
}

