/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableParam;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfRowParam {
    private List<XEasyPdfCell> cells = new ArrayList<XEasyPdfCell>(10);
    private Float marginLeft;
    private Float marginTop = Float.valueOf(0.0f);
    private Float height = Float.valueOf(0.0f);
    private Float beginX;
    private Float beginY;
    private String fontPath;
    private PDFont font;
    private Float fontSize;
    private XEasyPdfTextStyle style;

    void init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row) throws IOException {
        XEasyPdfTableParam tableParam = table.getParam();
        if (this.style == null) {
            this.style = tableParam.getStyle();
        }
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.getFont(document, this.fontPath, tableParam.getFont());
        }
        if (this.fontSize == null) {
            this.fontSize = Float.valueOf(tableParam.getFontSize());
        }
        for (XEasyPdfCell cell : this.cells) {
            if (cell == null) continue;
            cell.init(document, row);
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        Float pageY = page.getParam().getPageY();
        if (pageY == null) {
            this.beginY = Float.valueOf(rectangle.getHeight() - tableParam.getMarginTop().floatValue() - this.height.floatValue() - this.marginTop.floatValue());
        } else {
            float currentY;
            float footerHeight = 0.0f;
            if (page.getParam().isAllowFooter() && page.getParam().getFooter() != null) {
                footerHeight = page.getParam().getFooter().getHeight();
            }
            if ((currentY = pageY.floatValue() - this.height.floatValue() - this.marginTop.floatValue() + 1.0f) - footerHeight <= tableParam.getMarginBottom().floatValue()) {
                page.enablePosition();
                page.addNewPage(document, rectangle);
                page.disablePosition();
                this.beginY = Float.valueOf(page.getParam().getPageY() == null ? rectangle.getHeight() - tableParam.getMarginTop().floatValue() - this.height.floatValue() - this.marginTop.floatValue() : page.getParam().getPageY().floatValue() - tableParam.getMarginTop().floatValue() - this.height.floatValue() - this.marginTop.floatValue());
                this.beginX = null;
            } else {
                this.beginY = Float.valueOf(currentY);
            }
        }
        if (this.beginX == null) {
            this.beginX = this.marginLeft != null ? this.marginLeft : tableParam.getMarginLeft();
        }
    }

    public List<XEasyPdfCell> getCells() {
        return this.cells;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public XEasyPdfTextStyle getStyle() {
        return this.style;
    }

    public XEasyPdfRowParam setCells(List<XEasyPdfCell> cells) {
        this.cells = cells;
        return this;
    }

    public XEasyPdfRowParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfRowParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfRowParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfRowParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfRowParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfRowParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfRowParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfRowParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfRowParam setStyle(XEasyPdfTextStyle style) {
        this.style = style;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfRowParam)) {
            return false;
        }
        XEasyPdfRowParam other = (XEasyPdfRowParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<XEasyPdfCell> this$cells = this.getCells();
        List<XEasyPdfCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        XEasyPdfTextStyle this$style = this.getStyle();
        XEasyPdfTextStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfRowParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<XEasyPdfCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        XEasyPdfTextStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfRowParam(cells=" + this.getCells() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", style=" + (Object)((Object)this.getStyle()) + ")";
    }
}

