/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfTableParam {
    private List<XEasyPdfRow> rows = new ArrayList<XEasyPdfRow>(10);
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(5.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float beginX;
    private Float beginY;
    private String fontPath;
    private PDFont font;
    private float fontSize = 12.0f;
    private XEasyPdfTextStyle style = XEasyPdfTextStyle.LEFT;
    private boolean isDraw = false;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath);
        }
    }

    public List<XEasyPdfRow> getRows() {
        return this.rows;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public XEasyPdfTextStyle getStyle() {
        return this.style;
    }

    public boolean isDraw() {
        return this.isDraw;
    }

    public XEasyPdfTableParam setRows(List<XEasyPdfRow> rows) {
        this.rows = rows;
        return this;
    }

    public XEasyPdfTableParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfTableParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfTableParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfTableParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfTableParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfTableParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfTableParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfTableParam setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfTableParam setStyle(XEasyPdfTextStyle style) {
        this.style = style;
        return this;
    }

    public XEasyPdfTableParam setDraw(boolean isDraw) {
        this.isDraw = isDraw;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTableParam)) {
            return false;
        }
        XEasyPdfTableParam other = (XEasyPdfTableParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<XEasyPdfRow> this$rows = this.getRows();
        List<XEasyPdfRow> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        if (Float.compare(this.getFontSize(), other.getFontSize()) != 0) {
            return false;
        }
        XEasyPdfTextStyle this$style = this.getStyle();
        XEasyPdfTextStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        return this.isDraw() == other.isDraw();
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTableParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<XEasyPdfRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getFontSize());
        XEasyPdfTextStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        result = result * 59 + (this.isDraw() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "XEasyPdfTableParam(rows=" + this.getRows() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", style=" + (Object)((Object)this.getStyle()) + ", isDraw=" + this.isDraw() + ")";
    }
}

